/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse vec4(0.0,0.0, 0.0,0.0)

/////////////////////////////////////////////////////////////////////////////////

const float PI=3.14159265358979323846;
float speed=iGlobalTime*0.2975;
float r = .1;
float time = sin (iGlobalTime)*.4;

float Power =8.0;

float marched = 0.0;
float scale = .0;
float min_distance = 1.0;
float max_distance = 3.2;


vec2 rotate(vec2 k,float t)
	{
	return vec2(cos(t)*k.x-sin(t)*k.y,sin(t)*k.x+cos(t)*k.y);
	}

float sphere( vec3 pos){
vec3 z = pos;
	
	//Power += 2.0;
	
	float dr = .4;
	float r = 0.0;
	for (int i = 0; i < 8 ; i++) {
		r = length(z);
		if (r>2.0) break;
		
		// convert to polar coordinates
		float theta = acos( z.z/r );
float phi = atan( z.y,z.x );
		dr =  pow( r, Power-1.0)*Power*dr + 2.0;
		
		// scale and rotate the point
		float zr = pow( r,Power);
		theta = theta*Power;
		phi = phi*Power;
		
		// convert back to cartesian coordinates
		z = (vec3(sin(theta)*cos(phi), sin(phi)*sin(theta), cos(theta))*zr);

		z+=pos;
	}
	return 0.5*log(r)*r/dr;
}

float rm(vec3 origin, vec3 ray) {
	float distance_marched = min_distance;

	for (int i=0; i<80; i++) {
		
		float step_distance = sphere(origin + ray*distance_marched);
		if (abs(step_distance) < 0.009 ) {
			return distance_marched/(max_distance-min_distance);
		}
		distance_marched += step_distance;
		marched = distance_marched;
		if (distance_marched > max_distance) {
			return -1.0;
		}
	}
	return -1.0;
}

vec3 render(vec2 q) {
	vec3 eye = vec3(0.0, .2, -3.0 + time/ 2.0 );
	vec3 screen = vec3(q,1.0);
	vec3 ray = normalize(screen - eye);
	ray.yz=rotate(ray.yz,PI*0.11*sin(speed*0.825));	// rotation x
	ray.zx=rotate(ray.zx,-PI*time*0.25);				// rotation y
	ray.xy=rotate(ray.xy,speed*PI*.2);					// rotation z

float s = rm(eye, ray);
	
	vec3 col;
	
	if (s == -1.0) {
				col =  vec3(0.0);

	} else {
	
   		col = vec3(s-.8*.8+0.4*q.y *sin(q.x))*marched/1.76;
		col.rg *= marched*.83;
		
	}
	
	return col;
}

void main()
{
	vec2 q = (gl_FragCoord.xy*2.0 - iResolution.xy) / iResolution.y;
	
	vec3 col = render(q);
	q.x=col.x;
	q.y=col.y;	
   gl_FragColor = vec4(col,length(col)); 	
}
